/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Vibration;

public class BilbaoReader
extends AtomSetCollectionReader {
    private boolean getHigh;
    private boolean getSym;
    private boolean normDispl;
    private boolean doDisplace;
    private String kvec;
    private int i0;
    private int nAtoms;
    private boolean isBCSfile;

    public void initializeReader() throws Exception {
        this.normDispl = !this.checkFilterKey("NONORM");
        this.doDisplace = this.isTrajectory;
        this.getSym = true;
        this.getHigh = this.checkFilterKey("HIGH") && !this.doDisplace;
        this.asc.vibScale = 1;
        this.appendLoadNote("Bilbao Crystallographic Server\ncryst@wm.lc.ehu.es");
        if (this.rd().indexOf("<") < 0) {
            this.readBilbaoDataFile();
            this.continuing = false;
        }
    }

    protected boolean checkLine() throws Exception {
        if (this.line.contains(">Bilbao Crystallographic Server<")) {
            this.line = this.line.substring(this.line.lastIndexOf(">") + 1).trim();
            if (this.line.length() > 0) {
                this.appendLoadNote(this.line + "\n");
            }
        } else if (this.line.contains("High symmetry structure<")) {
            if (this.getHigh) {
                this.readBilbaoFormat("high symmetry", Float.NaN);
            }
        } else if (this.line.contains("Low symmetry structure<")) {
            if (!this.doDisplace) {
                this.readBilbaoFormat("low symmetry", Float.NaN);
            }
        } else if (this.line.contains("structure in the subgroup basis<")) {
            if (!this.doDisplace) {
                this.readBilbaoFormat("high symmetry in the subgroup basis", Float.NaN);
            }
        } else if (this.line.contains("Low symmetry structure after the origin shift<")) {
            this.readBilbaoFormat("low symmetry after origin shift", Float.NaN);
        } else if (this.line.contains("<h3>Irrep:")) {
            this.readVirtual();
        }
        return true;
    }

    private void readBilbaoDataFile() throws Exception {
        this.isBCSfile = true;
        this.checkComment();
        while (this.line != null) {
            this.readBilbaoFormat(null, Float.NaN);
            if (this.rdLine() == null || this.line.indexOf("##disp-par##") < 0) {
                this.applySymmetryAndSetTrajectory();
                continue;
            }
            this.readDisplacements(1.0f);
            this.rdLine();
        }
    }

    private boolean checkComment() {
        if (!this.line.startsWith("#") || this.line.indexOf("disp-par") >= 0) {
            return false;
        }
        if (this.isBCSfile) {
            this.appendLoadNote(this.line);
            if (this.line.startsWith("# Title:")) {
                this.asc.setAtomSetName(this.line.substring(8).trim());
            }
        }
        return true;
    }

    private void readBilbaoFormat(String title, float fAmp) throws Exception {
        int i;
        int intTableNo;
        this.setFractionalCoordinates(true);
        if (!this.doGetModel(++this.modelNumber, title)) {
            return;
        }
        this.asc.newAtomSet();
        if (this.line.startsWith("Bilbao Crys:")) {
            title = this.line.substring(13).trim();
            this.rdLine();
        }
        this.setTitle(title);
        int ptPre = this.line.indexOf("<pre>");
        if (ptPre >= 0) {
            this.line = this.line.substring(ptPre + 5);
        }
        if ((intTableNo = this.parseIntStr(this.line)) == 0) {
            this.setSpaceGroupName("bilbao:" + this.line.substring(2));
        } else {
            while (intTableNo < 0 && this.rdLine() != null) {
                intTableNo = this.parseIntStr(this.line);
            }
            this.setSpaceGroupName("bilbao:" + intTableNo);
        }
        float[] data = new float[6];
        this.fillFloatArray(null, 0, data);
        for (i = 0; i < 6; ++i) {
            this.setUnitCellItem(i, data[i]);
        }
        this.i0 = this.asc.ac;
        i = this.nAtoms = this.parseIntStr(this.rdLine());
        while (--i >= 0) {
            String[] tokens = PT.getTokens((String)this.rdLine());
            if (!this.getSym && tokens[1].contains("_")) continue;
            if (tokens.length == 3) {
                this.addAtomXYZSymName(tokens, 0, "Be", "Be1");
                continue;
            }
            this.addAtomXYZSymName(tokens, 3, tokens[0], tokens[0] + tokens[1]);
        }
        if (Float.isNaN(fAmp)) {
            if (ptPre >= 0) {
                this.applySymmetryAndSetTrajectory();
            }
            return;
        }
        this.line = null;
        this.readDisplacements(fAmp);
    }

    private void readDisplacements(float fAmp) throws Exception {
        int i;
        for (i = 0; i < this.nAtoms; ++i) {
            if (this.line == null) {
                this.rdLine();
            }
            String[] tokens = PT.split((String)this.line, (String)"x|x");
            if (this.getSym || !tokens[0].contains("_")) {
                this.asc.atoms[this.i0 + i].vib = V3.new3((float)this.parseFloatStr(tokens[1]), (float)this.parseFloatStr(tokens[2]), (float)this.parseFloatStr(tokens[3]));
            }
            this.line = null;
        }
        this.applySymmetryAndSetTrajectory();
        i = this.asc.ac;
        while (--i >= this.i0) {
            Atom a = this.asc.atoms[i];
            if (a.vib == null) continue;
            Vibration v = new Vibration();
            v.setT((T3)a.vib);
            a.vib = v;
            this.asc.getSymmetry().toCartesian((T3)v, true);
            v.scale(1.0f / fAmp);
        }
        this.appendLoadNote(this.asc.ac - this.i0 + " displacements");
    }

    private void setTitle(String title) {
        if (title != null) {
            this.asc.setAtomSetName(title);
            this.appendLoadNote(title);
        }
    }

    private String rdLine() throws Exception {
        while (this.rd() != null && (this.line.trim().length() == 0 || this.checkComment())) {
        }
        return this.line;
    }

    private void readVirtual() throws Exception {
        if (this.line.contains("<h3>K-vector:")) {
            this.kvec = this.line.substring(this.line.indexOf("("), this.line.indexOf(")") + 1);
        }
        String s = this.getLinesUntil("\"BCS\"");
        int pt = s.indexOf("The amplitude");
        pt = s.indexOf("=", pt);
        String amp = s.substring(pt + 2, s.indexOf(" ", pt + 2));
        float fAmp = this.normDispl ? this.parseFloatStr(amp) : 1.0f;
        String irrep = this.getAttr(s, "irrep");
        if (irrep.indexOf(":") >= 0) {
            irrep = irrep.substring(0, irrep.indexOf(":"));
        }
        this.line = this.line.substring(this.line.indexOf("value=") + 7);
        this.readBilbaoFormat(this.kvec + " " + irrep + " (" + amp + " Ang.)", fAmp);
    }

    private String getAttr(String s, String key) {
        int pt = s.indexOf("value", s.indexOf("\"" + key + "\""));
        s = PT.getQuotedStringAt((String)s, (int)pt);
        s = PT.rep((String)s, (String)"<i>", (String)"");
        s = PT.rep((String)s, (String)"</i>", (String)"");
        return s.trim();
    }

    private String getLinesUntil(String key) throws Exception {
        SB sb = new SB();
        do {
            sb.append(this.line);
        } while (!this.rd().contains(key));
        return sb.toString();
    }
}

